########### Permute Event onsets ###########
# This function will cleaned data from 1_Clean raw in order to test if permuting the Event onset vector changes Unit Direction distribution. Steps:
# - Load data from Clean raw
# - Permute each onset vector for each Event ID
# - Extract Perievent time course for each event for each unit (same as in 2_filter_data)
# - Threshold each unit for up/down firing (again using function from 2_filter_data)
# - Save all permutation as separate file



# Main function ---------------------------------------------------------------------------------------------------
permute_data <- function(i, Data){
  tryCatch({

      log.name = "logz.txt"
      log.name <- paste0(i, "_", log.name)
      # Set up logger
      flog.logger(name = log.name, threshold = threshold, appender = appender.file(paste0(output.folder, log.name, ".log")))
      flog.threshold(threshold, name = log.name)
      
      flog.info(paste0("Initializing: ", format(Sys.Date(), "%d %B, %Y")), name = log.name)
      
      #load data
      flog.info(paste0("!!!......Starting iteration: " , i, "......!!!"), name = log.name)
      flog.info("Permuting data....", name = log.name)
      
      
      # Get perievents
      flog.info("Init perievent", name = log.name)
      flog.info(paste0("Permute: ", permute), name = log.name)
      Data.perievents <- get_perievents(Data, 
                                        group.columns = group.columns, 
                                        protocol.columns = protocol.columns, 
                                        perievent.columns = perievent.columns,
                                        before = before, after = after,
                                        bin.size = bin.size, 
                                        permute)
      
      # Normalize and threshold data
      flog.info("Init threshold", name = log.name)
      Data.threshold <- threshold_units(Data.perievents$Data.event, group.columns, 
                                        normalize.spikes.per.event, min.time.normalization, max.time.normalization,
                                        z.threshold, threshold.min.time, threshold.max.time, 
                                        one.sample.t.threshold, one.sample.to.zero)
      
      write_rds(Data.threshold, path = paste0(output.folder, i, "_", Units.thresholded), "gz", compression = 9L)
      
      flog.info("It is done!", name = log.name)
      
      gc()
    
    
  }, error = function(e) {
    flog.error("ERROR!", name = log.name)
    flog.error(e, name = log.name)
  })
}


# Load libraries
suppressWarnings(library(tidyverse))
suppressWarnings(library(futile.logger))

suppressWarnings(library(furrr))
plan(multiprocess) #multiprocess

# Load config file
source("./R/config_session_v2_permutation.R")
source('./R/2_filter_data_functions_permute.R')

Data <- read_rds(path = paste0(output.folder, cleaned.raw.data))

Data <- Data %>% filter(Area.brain == "STN")

future_map(1:5000, permute_data, Data, .progress = TRUE)
